/* CYGNUS LOCAL */
/* This is just like the default gvarargs.h
   except for differences described below.  */

/* Define __gnuc_va_list.  */

#ifndef __GNUC_VA_LIST
#define __GNUC_VA_LIST

typedef long __va_greg;
typedef double __va_freg;

typedef struct {
  __va_greg * __va_next_o;		/* next available register */
  __va_greg * __va_next_o_limit;	/* past last available register */
  __va_freg * __va_next_fp;		/* next available fp register */
  __va_freg * __va_next_fp_limit;	/* last available fp register */
  __va_greg * __va_next_stack;		/* next extended word on stack */
} __gnuc_va_list;

#endif /* __GNUC_VA_LIST */

/* If this is for internal libc use, don't define anything but
   __gnuc_va_list.  */
#if defined (_STDARG_H) || defined (_VARARGS_H)

#ifdef _STDARG_H

#define va_start(AP, LASTARG) \
__extension__ \
  ({ \
     AP.__va_next_fp = (__va_freg *) __builtin_saveregs (); \
     AP.__va_next_fp_limit = (AP.__va_next_fp + \
			      (__builtin_args_info (1) < 8 ? 8 - __builtin_args_info (1) : 0)); \
     AP.__va_next_o = (__va_greg *) AP.__va_next_fp_limit; \
     AP.__va_next_o_limit = (AP.__va_next_o + \
			     (__builtin_args_info (0) < 4 ? 4 - __builtin_args_info (0) : 0)); \
     AP.__va_next_stack = (__va_greg *) __builtin_next_arg (LASTARG); \
  })

#else

#define va_alist  __builtin_va_alist
#define va_dcl    int __builtin_va_alist;...

#define va_start(AP) \
__extension__ \
  ({ \
     AP.__va_next_fp = (__va_freg *) __builtin_saveregs (); \
     AP.__va_next_fp_limit = (AP.__va_next_fp + \
			      (__builtin_args_info (1) < 8 ? 8 - __builtin_args_info (1) : 0)); \
     AP.__va_next_o = (__va_greg *) AP.__va_next_fp_limit; \
     AP.__va_next_o_limit = (AP.__va_next_o + \
			     (__builtin_args_info (0) < 4 ? 4 - __builtin_args_info (0) : 0)); \
     AP.__va_next_stack = (__va_greg *) __builtin_next_arg (__builtin_va_alist) \
       - (__builtin_args_info (0) >= 4 || __builtin_args_info (1) >= 8 ? 1 : 0); \
  })

#endif

#ifndef va_end
void va_end (__gnuc_va_list);		/* Defined in libgcc.a */

/* Values returned by __builtin_classify_type.  */

enum __va_type_classes {
  __no_type_class = -1,
  __void_type_class,
  __integer_type_class,
  __char_type_class,
  __enumeral_type_class,
  __boolean_type_class,
  __pointer_type_class,
  __reference_type_class,
  __offset_type_class,
  __real_type_class,
  __complex_type_class,
  __function_type_class,
  __method_type_class,
  __record_type_class,
  __union_type_class,
  __array_type_class,
  __string_type_class,
  __set_type_class,
  __file_type_class,
  __lang_type_class
};

#endif
#define va_end(pvar)	((void)0)

/* RECORD_TYPE args passed using the C calling convention are
   passed by invisible reference.  ??? RECORD_TYPE args passed
   in the stack are made to be word-aligned; for an aggregate that is
   not word-aligned, we advance the pointer to the first non-reg slot.  */

#define va_arg(pvar,TYPE)					\
__extension__							\
(*({int __type = __builtin_classify_type (* (TYPE *) 0);	\
  void * __result;						\
  if (__type == __real_type_class && sizeof(TYPE) == 4)		\
						/* float? */	\
    {								\
      __va_freg *__r;						\
      if (pvar.__va_next_fp < pvar.__va_next_fp_limit)		\
	__r = (__va_freg *) pvar.__va_next_fp++;		\
      else							\
	__r = (__va_freg *) pvar.__va_next_stack++;		\
      __result = (char *) __r;					\
    }								\
  else if (__type < __record_type_class)	/* integer? */	\
    {								\
      __va_greg *__r;						\
      if (pvar.__va_next_o < pvar.__va_next_o_limit) 		\
	{							\
	  __r = (__va_greg *) pvar.__va_next_o;			\
          pvar.__va_next_o += (sizeof (TYPE) + 3) / 4;		\
	}							\
      else							\
	{							\
          __r = (__va_greg *) pvar.__va_next_stack;             \
          pvar.__va_next_stack += (sizeof (TYPE) + 3) / 4;	\
	}							\
      __result = (char *) __r;					\
    }								\
  else /* aggregate object */					\
    {								\
      void **__r;						\
      if (pvar.__va_next_o < pvar.__va_next_o_limit)		\
	__r = (void **) pvar.__va_next_o++;			\
      else							\
	__r = (void **) pvar.__va_next_stack++;			\
      __result = *__r;						\
    }								\
  (TYPE *) __result;}))

#endif /* defined (_STDARG_H) || defined (_VARARGS_H) */
